/*
 * Decompiled with CFR 0.152.
 */
package com.natrificial.util.license;

import java.util.Date;

public abstract class License {
    static final int MILLISEC_DAY = 86400000;
    static final int SCRAMBLE = 6505;
    static final String NUMBERS = "0123456789ABCDEF";
    static final String ZEROS = "0000";
    public static final byte PROD_SITEBRAIN = 1;
    public static final byte PROD_SDK = 2;
    public static final byte T_NATRIFICIAL = 1;
    public static final byte T_FREE = 2;
    public static final byte T_TEST = 3;
    public static final byte T_PUBLIC = 4;
    public static final byte T_PRIVATE = 5;
    public static final byte EXP_NEVER = 1;
    public static final byte EXP_1DAY = 2;
    public static final byte EXP_7DAYS = 3;
    public static final byte EXP_30DAYS = 4;
    public static final byte EXP_90DAYS = 5;
    public static final byte EXP_1YEAR = 6;
    public static final byte CAP_UNLIMITED = 1;
    public static final byte CAP_30 = 2;
    public static final byte CAP_100 = 3;
    public static final byte CAP_300 = 4;
    public static final byte CAP_1000 = 5;
    public static final byte CAP_3000 = 6;
    public static final byte CAP_10000 = 7;
    int prod = 0;
    int type = 0;
    int expires = 0;
    int capacity = 0;
    int m_created = 0;
    int m_expires = 0;
    String m_url;
    boolean m_valid;

    public int getCapacity() {
        switch (this.capacity) {
            case 1: {
                return 0;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 100;
            }
            case 4: {
                return 300;
            }
            case 5: {
                return 1000;
            }
            case 6: {
                return 3000;
            }
            case 7: {
                return 10000;
            }
        }
        return 0;
    }

    int getDay() {
        Date date = new Date();
        return (int)(date.getTime() / 86400000L);
    }

    public boolean isValid() {
        return this.m_valid;
    }

    int checksum(int n, int n2, String string) {
        int n3 = 6505;
        int n4 = 0;
        while (n4 < string.length()) {
            n3 *= string.charAt(n4);
            ++n4;
        }
        n4 = (n + n2) * n3 - n * n2;
        return n4;
    }

    public String toString() {
        if (!this.m_valid) {
            return "License(INVALID)";
        }
        String string = "License(" + this.type + ", " + this.capacity + ", " + this.expires + ")";
        if (!this.isDateValid()) {
            return string + " EXPIRED";
        }
        return string;
    }

    public boolean isDateValid() {
        int n = this.getDay();
        return this.m_expires == 0 || n >= this.m_created && n <= this.m_expires;
    }

    void init() {
        int n = 0;
        switch (this.expires) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 7;
                break;
            }
            case 4: {
                n = 30;
                break;
            }
            case 5: {
                n = 90;
                break;
            }
            case 6: {
                n = 365;
            }
        }
        this.m_expires = n == 0 ? 0 : this.m_created + n;
    }
}

