/*
 * Decompiled with CFR 0.152.
 */
package com.natrificial.applet.lite;

import com.natrificial.applet.lite.Brain;
import com.natrificial.applet.lite.PlexConfiguration;
import com.natrificial.applet.lite.Thought;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ThoughtDrawable
extends Thought {
    Brain m_brain = null;
    int m_x = 0;
    int m_y = 0;
    int m_state = 0;
    int m_height = 0;
    int m_width = 0;
    int m_wideWidth = 0;
    int m_wideX = 0;
    Color m_textColor;
    String m_useName;
    Rectangle m_rect;
    Point[] m_gatePoints = new Point[3];
    Rectangle[] m_gateRects = new Rectangle[3];
    int[] m_gateStates = new int[3];
    PlexConfiguration m_config;
    int m_configNumber;
    static final int TYPE = 15;
    static final int PARENT = 1;
    static final int CHILD = 2;
    static final int JUMP = 3;
    static final int SIBLING = 4;
    static final int DISTANT = 5;
    static final int ACTIVE = 6;
    static final int DISAPPEARING = 16;
    static final int ZOOM = 32;
    static final int PARENTGATE = 0;
    static final int CHILDGATE = 1;
    static final int JUMPGATE = 2;
    static final int EMPTY = 0;
    static final int USED = 1;
    static final int MORE = 2;

    public void calculateGateStates() {
        this.m_textColor = this.m_config.m_plex.m_highlightThoughtNum == this.getNumber() ? this.m_brain.getColor(4) : (this.isActivated() && this.getNumber() != this.m_config.m_activeNum ? this.m_brain.getColor(5) : this.m_brain.getColor(2));
        this.m_gateStates[0] = this.calculateGateState(this.parents(), 1);
        this.m_gateStates[1] = this.calculateGateState(this.children(), 2);
        this.m_gateStates[2] = this.calculateGateState(this.jumps(), 3);
    }

    public void draw(Graphics graphics) {
        if (this.m_config.m_plex.m_highlightThoughtNum == this.getNumber()) {
            this.drawLinks(graphics, false);
        }
        if (this.m_config.m_activeNum == this.getNumber()) {
            graphics.setColor(this.m_brain.getColor(6));
            graphics.fillRoundRect(this.m_rect.x - 1, this.m_rect.y, this.m_rect.width + 2, this.m_rect.height, this.m_rect.height / 3, this.m_rect.height / 3);
            graphics.setColor(this.m_brain.getColor(7));
            graphics.drawRoundRect(this.m_rect.x - 1, this.m_rect.y, this.m_rect.width + 2, this.m_rect.height, this.m_rect.height / 3, this.m_rect.height / 3);
        }
        int n = this.m_rect.x;
        if (this.m_config.m_plex.m_highlightThoughtNum == this.getNumber()) {
            if (this.m_rect.x + this.m_wideWidth > this.m_config.m_plex.m_width) {
                n = this.m_wideX;
            }
            graphics.setColor(this.m_brain.getColor(8));
            graphics.fillRoundRect(n - 1, this.m_rect.y, this.m_wideWidth + 2, this.m_rect.height, this.m_rect.height / 3, this.m_rect.height / 3);
            graphics.setColor(this.m_brain.getColor(9));
            graphics.drawRoundRect(n - 1, this.m_rect.y, this.m_wideWidth + 2, this.m_rect.height, this.m_rect.height / 3, this.m_rect.height / 3);
        }
        Font font = this.m_config.m_plex.m_fontManager.getFont(this.m_height);
        graphics.setFont(font);
        FontMetrics fontMetrics = this.m_config.m_plex.m_fontManager.getFontMetrics(this.m_height);
        graphics.setColor(this.m_textColor);
        String string = this.m_config.m_plex.m_highlightThoughtNum == this.getNumber() ? this.getName().toString() : this.m_useName;
        graphics.drawString(string, n, this.m_rect.y + this.m_rect.height - fontMetrics.getDescent());
        if (this.m_brain.getPrefs().m_bUnderlineLinks && this.getLocation() != null && this.getLocation().length() != 0) {
            graphics.drawLine(n, this.m_rect.y + this.m_rect.height - 1, n + this.m_rect.width, this.m_rect.y + this.m_rect.height - 1);
        }
        int n2 = 0;
        do {
            if (this.m_gateStates[n2] == 1 || this.m_gateStates[n2] == 0) {
                graphics.setColor(this.m_brain.getColor(10));
            } else {
                graphics.setColor(this.m_brain.getColor(11));
            }
            int n3 = this.m_gateRects[n2].x;
            if (n2 == 2 && this.m_config.m_plex.m_highlightThoughtNum == this.getNumber()) {
                n3 = n - this.m_gateRects[n2].width;
            }
            if (this.m_gateStates[n2] == 0) {
                graphics.drawOval(n3, this.m_gateRects[n2].y, this.m_gateRects[n2].width, this.m_gateRects[n2].height);
                continue;
            }
            graphics.fillOval(n3, this.m_gateRects[n2].y, this.m_gateRects[n2].width, this.m_gateRects[n2].height);
        } while (++n2 < 3);
    }

    ThoughtDrawable() {
    }

    ThoughtDrawable(Brain brain, int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, PlexConfiguration plexConfiguration, int n7) {
        super.copy(brain.getThought(n));
        this.m_brain = brain;
        this.m_x = n2;
        this.m_y = n3;
        this.m_state = n4;
        this.m_height = n5;
        this.m_width = n6;
        this.m_config = plexConfiguration;
        this.m_configNumber = n7;
        int n8 = 0;
        do {
            this.m_gatePoints[n8] = new Point(0, 0);
        } while (++n8 < 3);
        this.calculate(graphics);
    }

    public void calculate(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = this.m_config.m_plex.m_fontManager.getFontMetrics(this.m_height);
        int n2 = fontMetrics.getHeight();
        this.m_useName = this.getName().toString();
        this.m_wideWidth = n = fontMetrics.stringWidth(this.m_useName);
        if (n > this.m_width) {
            this.m_useName = new String(this.m_useName + "...");
        }
        while (n > this.m_width) {
            if (this.m_useName.length() < 5 || this.m_width == 0) {
                this.m_useName = "...";
                break;
            }
            this.m_useName = this.m_useName.substring(0, this.m_useName.length() - 5) + "...";
            n = fontMetrics.stringWidth(this.m_useName);
        }
        this.m_rect = new Rectangle(this.m_x - n / 2, this.m_y - n2 / 2, n, n2);
        if (this.m_rect.x + this.m_wideWidth > this.m_config.m_plex.m_width) {
            this.m_wideX = this.m_config.m_plex.m_width - this.m_wideWidth;
        }
        int n3 = n2 / 3;
        this.m_gatePoints[0].x = this.m_rect.x + this.m_rect.width / 2 - n2 / 3;
        this.m_gatePoints[0].y = this.m_rect.y;
        this.m_gatePoints[1].x = this.m_rect.x + this.m_rect.width / 2 + n2 / 3;
        this.m_gatePoints[1].y = this.m_rect.y + this.m_rect.height;
        if ((this.m_state & 0xF) != 3) {
            this.m_gatePoints[2].x = this.m_rect.x - n3 / 2 - 1;
            this.m_gatePoints[2].y = this.m_rect.y + this.m_rect.height / 2;
        } else {
            this.m_gatePoints[2].x = this.m_rect.x + this.m_rect.width + n3 / 2 + 1;
            this.m_gatePoints[2].y = this.m_rect.y + this.m_rect.height / 2;
        }
        int n4 = 0;
        do {
            this.m_gateRects[n4] = new Rectangle(this.m_gatePoints[n4].x - n3 / 2, this.m_gatePoints[n4].y - n3 / 2, n3, n3);
        } while (++n4 < 3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawLinks(Graphics graphics, boolean bl) {
        int n = 0;
        if (bl) {
            n = this.m_configNumber + 1;
        }
        int n2 = n;
        while (n2 < this.m_config.m_usedDrawables) {
            block13: {
                int n3 = this.isRelated(this.m_config.m_drawables[n2].getNumber());
                int n4 = 0;
                int n5 = 0;
                switch (n3) {
                    case 0: {
                        break block13;
                    }
                    case 3: {
                        n4 = 2;
                        n5 = 2;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        n5 = 0;
                        break;
                    }
                    case 1: {
                        n4 = 0;
                        n5 = 1;
                    }
                }
                if (this.m_config.m_plex.m_highlightThoughtNum != this.getNumber() && this.m_config.m_plex.m_highlightThoughtNum != this.m_config.m_drawables[n2].getNumber()) {
                    int n6 = this.m_config.m_drawables[n2].m_state;
                    if ((this.m_state & 0xF) == 6 || (n6 & 0xF) == 6 || (this.m_state & 0xF) == 1 && (n6 & 0xF) == 4 || (this.m_state & 0xF) == 4 && (n6 & 0xF) == 1) {
                        graphics.setColor(this.m_brain.getColor(12));
                    } else {
                        graphics.setColor(this.m_brain.getColor(13));
                    }
                } else {
                    graphics.setColor(this.m_brain.getColor(14));
                }
                graphics.drawLine(this.m_gatePoints[n4].x, this.m_gatePoints[n4].y, this.m_config.m_drawables[n2].m_gatePoints[n5].x, this.m_config.m_drawables[n2].m_gatePoints[n5].y);
            }
            ++n2;
        }
    }

    public boolean isLinkedToInvisibleThoughts() {
        int n = 0;
        do {
            if (this.m_gateStates[n] != 2) continue;
            return true;
        } while (++n < 3);
        return false;
    }

    public boolean hitTest(int n, int n2) {
        boolean bl = this.m_rect.inside(n, n2);
        int n3 = 0;
        do {
            bl |= this.m_gateRects[n3].inside(n, n2);
        } while (++n3 < 3);
        return bl;
    }

    public void copy(ThoughtDrawable thoughtDrawable) {
        super.copy(thoughtDrawable);
        this.m_brain = thoughtDrawable.m_brain;
        this.m_x = thoughtDrawable.m_x;
        this.m_y = thoughtDrawable.m_y;
        this.m_state = thoughtDrawable.m_state;
        this.m_height = thoughtDrawable.m_height;
        this.m_width = thoughtDrawable.m_width;
        this.m_wideWidth = thoughtDrawable.m_wideWidth;
        this.m_wideX = thoughtDrawable.m_wideX;
        this.m_textColor = thoughtDrawable.m_textColor;
        this.m_useName = thoughtDrawable.m_useName;
        this.m_rect = thoughtDrawable.m_rect;
        int n = 0;
        do {
            this.m_gatePoints[n] = thoughtDrawable.m_gatePoints[n];
            this.m_gateRects[n] = thoughtDrawable.m_gateRects[n];
            this.m_gateStates[n] = thoughtDrawable.m_gateStates[n];
        } while (++n < 3);
        this.m_config = thoughtDrawable.m_config;
        this.m_configNumber = thoughtDrawable.m_configNumber;
    }

    int calculateGateState(int[] nArray, int n) {
        int n2 = this.getNumRelates(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < this.m_config.m_usedDrawables) {
                if (nArray[n3] == this.m_config.m_drawables[n4].getNumber() && (this.m_config.m_drawables[n4].m_state & 0x10) == 0) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                return 2;
            }
            ++n3;
        }
        return 1;
    }
}

