/*
 * Decompiled with CFR 0.152.
 */
package com.natrificial.applet.lite;

import com.natrificial.applet.lite.Brain;
import com.natrificial.applet.lite.Cam;
import com.natrificial.applet.lite.FontManager;
import com.natrificial.applet.lite.Matrix;
import com.natrificial.applet.lite.MessageManager;
import com.natrificial.applet.lite.MovingPlexConfiguration;
import com.natrificial.applet.lite.PlexConfiguration;
import com.natrificial.applet.lite.Thought;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class Plex {
    static final int ACCURACY = 4;
    static final int MAXCLICKDIST = 10;
    static final int MINCAMSIZE = 10;
    static final int TIMETOZOOM = 20;
    static final int TIMETOUNZOOM = 15;
    static final int DEFCAMSIZE = 18;
    static final int BEGCAMSIZE = 120;
    Brain m_brain = null;
    Applet m_applet = null;
    Graphics m_graphics = null;
    PlexConfiguration m_current = null;
    PlexConfiguration m_last = null;
    PlexConfiguration m_prev = null;
    MovingPlexConfiguration m_moving = null;
    MessageManager m_messages = null;
    String m_target = new String("brainmain");
    Image m_wallpaper = null;
    MediaTracker m_wallpaperTracker = null;
    boolean m_wallpaperFailed = false;
    Random m_rand = new Random();
    Cam m_cam = new Cam();
    int m_angle = 0;
    int m_direction = 0;
    boolean m_highlightCam = false;
    boolean m_animation = true;
    boolean m_mouseInside = false;
    int m_width = 0;
    int m_height = 0;
    int m_lastMouseX = 0;
    int m_lastMouseY = 0;
    int m_startMouseX = 0;
    int m_startMouseY = 0;
    int m_sleepTime = 0;
    int m_numFrames = 0;
    double m_camSizeNow = 120.0;
    double m_camSizeDir = 0.0;
    int m_camSize = 18;
    int m_maxChildColumns = 4;
    int m_verticalCenter = 0;
    int m_fontHeight = (int)((double)this.m_camSize / 1.4);
    int m_dragState = 0;
    int m_dragThoughtNum = 0;
    int m_frame = 0;
    int m_stopFrame = 0;
    int m_highlightThoughtNum = 0;
    int m_lastHighlightThoughtNum = 0;
    int m_currentHighlightFrames = 0;
    int m_zoomedThoughtNum = 0;
    int m_maxDragDist = 0;
    static final double CAMSIZEMULTIPLIER = 2.3;
    FontManager m_fontManager = new FontManager();
    boolean finished = false;
    Vector m_launchQueue = new Vector();

    public void setMaxColumns(int n) {
        if (n > 0) {
            this.m_maxChildColumns = n;
        }
    }

    public void frameDrawn() {
    }

    public synchronized void checkHighlight(int n, int n2) {
        this.m_lastMouseX = n;
        this.m_lastMouseY = n2;
        this.removeHighlight();
        PlexConfiguration plexConfiguration = this.getVisiblePlexConfiguration();
        int n3 = plexConfiguration.m_usedDrawables - 1;
        while (n3 > -1) {
            if (plexConfiguration.m_drawables[n3].hitTest(n, n2)) {
                this.m_highlightThoughtNum = plexConfiguration.m_drawables[n3].getNumber();
                return;
            }
            --n3;
        }
        if (this.m_frame == 0 && this.m_dragState == 0) {
            n3 = Math.abs(n - this.m_width / 2) - 4;
            int n4 = Math.abs(n - this.m_width / 2) + 4;
            int n5 = Math.abs(n2 - this.m_verticalCenter) - 4;
            int n6 = Math.abs(n2 - this.m_verticalCenter) + 4;
            if (n3 * n3 + n5 * n5 < this.m_camSize * this.m_camSize && n4 * n4 + n6 * n6 > this.m_camSize * this.m_camSize) {
                this.m_highlightCam = true;
            }
        }
    }

    public void setContentTarget(String string) {
        if (string.length() > 0) {
            this.m_target = string;
        }
    }

    public void mouseClicked(Event event) {
    }

    public void mousePressed(Event event) {
        int n = event.x;
        int n2 = event.y;
        this.m_startMouseX = n;
        this.m_startMouseY = n2;
        this.m_maxDragDist = 0;
        this.m_lastMouseX = n;
        this.m_lastMouseY = n2;
        this.removeHighlight();
        PlexConfiguration plexConfiguration = this.getVisiblePlexConfiguration();
        int n3 = plexConfiguration.m_usedDrawables - 1;
        while (n3 > -1) {
            if (!plexConfiguration.m_drawables[n3].hitTest(n, n2) || plexConfiguration.m_activeNum != plexConfiguration.m_drawables[n3].getNumber() || this.m_frame == 0) {
                // empty if block
            }
            --n3;
        }
    }

    public void spinCam() {
        if (this.m_direction == 0 || this.m_angle % 60 == 0 && (double)this.m_rand.nextFloat() > 0.8) {
            this.m_direction = 2 + (int)(this.m_rand.nextFloat() * 1.0f);
            if ((double)this.m_rand.nextFloat() > 0.5) {
                this.m_direction = -this.m_direction;
            }
        }
        this.m_angle += this.m_direction;
    }

    public synchronized void mouseDragged(Event event) {
        int n = event.x;
        int n2 = event.y;
        if (Math.abs(n - this.m_startMouseX) > this.m_maxDragDist) {
            this.m_maxDragDist = Math.abs(n - this.m_startMouseX);
        }
        if (Math.abs(n2 - this.m_startMouseY) > this.m_maxDragDist) {
            this.m_maxDragDist = Math.abs(n2 - this.m_startMouseY);
        }
        this.m_lastMouseX = n;
        this.m_lastMouseY = n2;
    }

    Plex(Brain brain, Applet applet) {
        this.m_brain = brain;
        this.m_applet = applet;
        this.m_graphics = applet.getGraphics();
        this.m_applet.setLayout(null);
        this.m_fontManager.initialize(this.m_graphics, this.m_brain.getPrefs().m_font, 0, this.m_fontHeight * 3);
        this.m_numFrames = this.m_brain.getPrefs().m_numFrames;
        this.m_sleepTime = this.m_brain.getPrefs().m_sleepTime;
        this.m_current = new PlexConfiguration(this);
        this.m_last = new PlexConfiguration(this);
        this.m_moving = new MovingPlexConfiguration(this);
        this.m_messages = new MessageManager(brain.getPrefs());
    }

    public void mouseReleased(Event event) {
        boolean bl;
        this.m_dragThoughtNum = 0;
        this.m_dragState = 0;
        boolean bl2 = bl = (event.modifiers & 4) != 0;
        if (!bl && this.m_maxDragDist < 10) {
            this.customMouseClicked(event);
            return;
        }
    }

    public void mouseMoved(Event event) {
        int n = event.x;
        int n2 = event.y;
        this.checkHighlight(n, n2);
    }

    public void regeneratePlex() {
        Thought thought = this.m_brain.getActiveThought();
        if (thought != null) {
            PlexConfiguration plexConfiguration = new PlexConfiguration(thought, this);
            if (this.m_prev != null) {
                plexConfiguration.copy(this.m_prev);
                this.m_prev = null;
            }
            this.startAnimation(plexConfiguration, this.m_numFrames / 2, false);
            this.m_zoomedThoughtNum = 0;
        }
    }

    public void drawBackground(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        String string;
        if (!this.m_wallpaperFailed && (string = this.m_brain.getPrefs().m_wallpaper) != null && string.length() != 0) {
            if (this.m_wallpaper == null && this.m_wallpaperTracker == null) {
                URL uRL;
                if (string.startsWith("http://")) {
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                        this.m_wallpaperFailed = true;
                        this.drawBackground(graphics);
                        return;
                    }
                    this.m_wallpaper = this.m_applet.getImage(uRL);
                } else {
                    uRL = this.m_applet.getCodeBase();
                    this.m_wallpaper = this.m_applet.getImage(uRL, string);
                }
                this.m_wallpaperTracker = new MediaTracker(this.m_applet);
                this.m_wallpaperTracker.addImage(this.m_wallpaper, 0);
            }
            int n9 = this.m_wallpaper.getWidth(this.m_applet);
            int n10 = this.m_wallpaper.getHeight(this.m_applet);
            if (this.m_brain.getPrefs().m_tiled && n9 > 0 && n10 > 0) {
                n8 = 0;
                while (n8 < this.m_width) {
                    n7 = 0;
                    while (n7 < this.m_height) {
                        graphics.drawImage(this.m_wallpaper, n8, n7, n9, n10, this.m_applet);
                        n7 += n10;
                    }
                    n8 += n9;
                }
            } else {
                graphics.drawImage(this.m_wallpaper, 0, 0, this.m_width, this.m_height, this.m_applet);
            }
            if (this.m_wallpaperTracker == null) {
                return;
            }
            if (this.m_wallpaperTracker.checkAll()) {
                if (!this.m_wallpaperTracker.isErrorAny()) {
                    this.m_wallpaperTracker = null;
                    return;
                }
                this.m_wallpaperTracker = null;
                this.m_wallpaperFailed = true;
            }
        }
        int n11 = 100;
        double d = (double)this.m_height / ((double)n11 * 2.0);
        n8 = this.m_brain.getColor(1).getRed();
        n7 = this.m_brain.getColor(1).getGreen();
        int n12 = this.m_brain.getColor(1).getBlue();
        int n13 = this.m_brain.getColor(0).getRed();
        int n14 = this.m_brain.getColor(0).getGreen();
        int n15 = this.m_brain.getColor(0).getBlue();
        double d2 = (double)(n13 - n8) / (double)n11;
        double d3 = (double)(n14 - n7) / (double)n11;
        double d4 = (double)(n15 - n12) / (double)n11;
        int n16 = n6 = 0;
        while (n16 < n11) {
            n5 = (int)((double)n16 * d + 0.5);
            n4 = (int)((double)(n16 + 1) * d + 0.5);
            n3 = n8 + (int)((double)n16 * d2 + 0.5);
            n2 = n7 + (int)((double)n16 * d3 + 0.5);
            n = n12 + (int)((double)n16 * d4 + 0.5);
            graphics.setColor(new Color(n3, n2, n));
            graphics.fillRect(0, n5, this.m_width, n4);
            ++n16;
        }
        while (n16 < n11 * 2) {
            n5 = (int)((double)n16 * d + 0.5);
            n4 = (int)((double)(n16 + 1) * d + 0.5);
            n3 = n8 + (int)((double)(n11 * 2 - n16) * d2 + 0.5);
            n2 = n7 + (int)((double)(n11 * 2 - n16) * d3 + 0.5);
            n = n12 + (int)((double)(n11 * 2 - n16) * d4 + 0.5);
            graphics.setColor(new Color(n3, n2, n));
            graphics.fillRect(0, n5, this.m_width, n4);
            ++n16;
        }
    }

    public synchronized boolean ignoreLaunch(Thought thought) {
        int n = 0;
        int n2 = -1;
        Enumeration enumeration = this.m_launchQueue.elements();
        while (enumeration.hasMoreElements()) {
            Thought thought2 = (Thought)enumeration.nextElement();
            if (thought.getNumber() == thought2.getNumber()) {
                n2 = n;
            }
            ++n;
        }
        if (n2 >= 0) {
            int n3 = 0;
            while (n3 <= n2) {
                this.m_launchQueue.removeElementAt(n3);
                ++n3;
            }
            return true;
        }
        return false;
    }

    public void resize(int n, int n2) {
        this.m_width = n;
        this.m_height = n2;
        this.m_verticalCenter = (int)((double)this.m_height * (double)this.m_brain.getPrefs().m_verticalPercent / 100.0);
        if (this.m_brain.isLoaded()) {
            this.regeneratePlex();
        }
    }

    public synchronized void drawAnimation(Graphics graphics) {
        this.drawCam(graphics);
        this.spinCam();
        PlexConfiguration plexConfiguration = this.getVisiblePlexConfiguration();
        if (this.m_frame != 0) {
            this.m_moving.doMovement();
        }
        this.checkHighlight(this.m_lastMouseX, this.m_lastMouseY);
        plexConfiguration.draw(graphics);
        if (this.m_frame != 0) {
            ++this.m_frame;
            if (this.m_frame == this.m_stopFrame) {
                this.m_frame = 0;
            }
        }
        this.frameDrawn();
        if (!this.m_messages.isEmpty()) {
            Font font = this.m_fontManager.getFont(14);
            graphics.setFont(font);
            this.m_messages.draw(graphics, this.m_applet.bounds());
            this.m_messages.animate();
        }
    }

    public void launchThought(Thought thought) {
        String string = thought.getLocation().toString();
        if (this.launchDocument(string) == 1) {
            this.m_launchQueue.addElement(thought);
        }
    }

    public synchronized void startAnimation(PlexConfiguration plexConfiguration, int n, boolean bl) {
        if (n < 2) {
            n = 2;
        }
        if (this.m_animation) {
            PlexConfiguration plexConfiguration2 = this.getVisiblePlexConfiguration();
            this.m_last.copy(plexConfiguration2);
        } else {
            this.m_last.copy(plexConfiguration);
        }
        this.m_moving.calculateDeltas(this.m_last, plexConfiguration, n, bl);
        int n2 = 0;
        do {
            this.m_moving.m_scrolls[n2] = plexConfiguration.m_scrolls[n2];
        } while (++n2 < 4);
        this.m_current = plexConfiguration;
        this.m_frame = 1;
        this.m_stopFrame = n;
    }

    public void activateThought(Thought thought) {
        this.m_prev = null;
        this.m_brain.setActiveThoughtID(thought.getNumber());
        thought.setActivated();
        PlexConfiguration plexConfiguration = new PlexConfiguration(thought, this);
        this.startAnimation(plexConfiguration, this.m_numFrames, true);
        this.m_camSizeDir = -30.0 / (double)this.m_numFrames;
        if (this.m_camSizeNow != 120.0) {
            this.m_camSizeNow = 18.0;
        }
    }

    public void customMouseClicked(Event event) {
        boolean bl = (event.modifiers & 4) != 0;
        int n = event.x;
        int n2 = event.y;
        this.m_lastMouseX = n;
        this.m_lastMouseY = n2;
        this.removeHighlight();
        PlexConfiguration plexConfiguration = this.getVisiblePlexConfiguration();
        int n3 = plexConfiguration.m_usedDrawables - 1;
        while (n3 > -1) {
            if (plexConfiguration.m_drawables[n3].hitTest(n, n2) && (plexConfiguration.m_activeNum != plexConfiguration.m_drawables[n3].getNumber() || this.m_frame == 0)) {
                if (!bl) {
                    this.activateThought(plexConfiguration.m_drawables[n3]);
                    if (!this.m_brain.getPrefs().m_bOpenLinksManually || plexConfiguration.m_drawables[n3].getNumber() == plexConfiguration.m_activeNum) {
                        this.launchThought(plexConfiguration.m_drawables[n3]);
                    }
                }
                return;
            }
            --n3;
        }
        PlexConfiguration plexConfiguration2 = new PlexConfiguration();
        plexConfiguration2.copy(plexConfiguration);
        if (plexConfiguration2.mouseClicked(n, n2)) {
            this.startAnimation(plexConfiguration2, this.m_numFrames / 3, false);
        }
    }

    public void mouseEntered(Event event) {
        this.m_mouseInside = true;
    }

    public void drawCam(Graphics graphics) {
        this.m_camSizeNow += this.m_camSizeDir;
        if (this.m_camSizeNow >= (double)this.m_camSize && this.m_camSizeDir > 0.0 || (int)this.m_camSizeNow == this.m_camSize) {
            this.m_camSizeNow = this.m_camSize;
            this.m_camSizeDir = 0.0;
        }
        if (this.m_camSizeNow < 8.0) {
            this.m_camSizeDir *= -1.0;
        }
        int n = (int)this.m_camSizeNow;
        int n2 = (int)(2.5 * (double)n / 1.6);
        int n3 = this.m_width / 2;
        int n4 = this.m_verticalCenter;
        graphics.setColor(this.m_brain.getColor(15));
        int n5 = 0;
        do {
            Matrix matrix = new Matrix();
            Matrix matrix2 = new Matrix();
            Matrix matrix3 = new Matrix();
            matrix.setRotation(this.m_angle + n5);
            matrix2.setScale(n2);
            matrix3.setPosition(n3, n4);
            Matrix matrix4 = matrix.multiply(matrix);
            Matrix matrix5 = matrix4.multiply(matrix2);
            Matrix matrix6 = matrix5.multiply(matrix3);
            this.m_cam.reset();
            this.m_cam.translate(matrix6);
            this.m_cam.drawPoly(graphics);
        } while ((n5 += 120) < 360);
        graphics.drawOval(n3 - n, n4 - n, n * 2, n * 2);
    }

    public void mouseExited(Event event) {
        this.m_mouseInside = false;
        this.removeHighlight();
        this.m_lastMouseX = -1;
        this.m_lastMouseY = -1;
    }

    public synchronized PlexConfiguration getVisiblePlexConfiguration() {
        PlexConfiguration plexConfiguration = this.m_current;
        if (this.m_frame != 0) {
            plexConfiguration = this.m_moving;
        }
        return plexConfiguration;
    }

    public void removeHighlight() {
        if (this.m_highlightThoughtNum != 0) {
            this.m_highlightThoughtNum = 0;
        }
        this.m_highlightCam = false;
    }

    public int launchDocument(String string) {
        if (string.compareTo("") != 0) {
            AppletContext appletContext = this.m_applet.getAppletContext();
            if (string.startsWith("mailto:")) {
                try {
                    URL uRL = new URL(string);
                    appletContext.showDocument(uRL, "_top");
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return -1;
                }
                return 0;
            }
            if (!string.startsWith("http://") && !string.startsWith("https://")) {
                string = this.m_applet.getCodeBase() + string;
            }
            try {
                URL uRL = new URL(string);
                appletContext.showDocument(uRL, this.m_target);
                return 1;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return -1;
            }
        }
        return 0;
    }

    public boolean isAnimating() {
        boolean bl = !this.finished;
        boolean bl2 = this.m_brain.getPrefs().m_bCamIdle ? this.m_mouseInside : true;
        this.finished = !bl2 && this.m_messages.isEmpty() && this.m_frame == 0 && this.m_camSizeDir == 0.0 && this.m_brain.isLoaded();
        return bl;
    }
}

