/*
 * Decompiled with CFR 0.152.
 */
package com.natrificial.applet.lite;

import com.natrificial.applet.lite.Message;
import com.natrificial.applet.lite.Preferences;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class MessageManager {
    static final int MIN_DISTANCE = 64;
    private Vector m_messages = new Vector();
    private Preferences m_prefs = null;

    public void clearMessages() {
        this.m_messages.removeAllElements();
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        Enumeration enumeration = this.m_messages.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            if (message.isValid(rectangle)) {
                message.draw(this.m_prefs, graphics, rectangle.width, rectangle.height);
                continue;
            }
            this.m_messages.removeElement(message);
            message = null;
        }
    }

    public MessageManager(Preferences preferences) {
        this.m_prefs = preferences;
    }

    public void addMessage(String string) {
        this.m_messages.addElement(new Message(string));
    }

    public boolean isEmpty() {
        return this.m_messages.isEmpty();
    }

    public void animate() {
        Enumeration enumeration = this.m_messages.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            if (message.move() < 64) break;
        }
    }
}

