/*
 * Decompiled with CFR 0.152.
 */
package com.natrificial.applet.lite;

import com.natrificial.applet.lite.BrainStoreImpl;
import com.natrificial.applet.lite.BrainStoreURL;
import com.natrificial.applet.lite.Preferences;
import com.natrificial.applet.lite.Thought;
import java.awt.Color;
import java.util.Enumeration;

public class Brain {
    static final int T_NONE = 0;
    static final int T_JBR = 1;
    static final int T_JBC = 2;
    private BrainStoreImpl m_store = null;
    private boolean m_loaded = false;
    private Preferences m_prefs = new Preferences();
    private int m_format = 1;

    public Thought getActiveThought() {
        return this.m_store.getThought(this.m_store.getActiveThoughtID());
    }

    public void open(String string, String string2, int n) throws Exception {
        this.m_format = n;
        if (string == null) {
            if (string2 == null) {
                throw new Exception("No brain name");
            }
            string2.toUpperCase();
            int n2 = string2.lastIndexOf(47);
            if (n2 < 0) {
                throw new Exception("Brain location invalid");
            }
            string = string2.substring(0, n2);
            int n3 = string2.lastIndexOf(46);
            if (n3 < 0) {
                throw new Exception("Brain location invalid");
            }
            String string3 = string2.substring(n3, string2.length());
            if (!string3.equalsIgnoreCase(".jbc")) {
                throw new Exception("Incorrect brain type");
            }
            this.m_format = 2;
            string2 = string2.substring(n2 + 1, n3);
        }
        switch (this.m_format) {
            case 2: {
                this.m_store = new BrainStoreURL(string);
                break;
            }
            default: {
                throw new Exception("Invalid Brain Type");
            }
        }
        if (this.m_store != null) {
            this.m_store.open(string2);
            this.m_loaded = true;
        }
    }

    public Thought findThoughtStartingWith(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string.toUpperCase();
        Thought thought = null;
        Enumeration enumeration = this.m_store.getEnumerator();
        while (enumeration.hasMoreElements()) {
            Thought thought2 = (Thought)enumeration.nextElement();
            String string3 = thought2.getName().toString().toUpperCase();
            if (!string3.startsWith(string2)) continue;
            thought = thought2;
            break;
        }
        return thought;
    }

    public int getFormat() {
        return this.m_format;
    }

    public int getThoughtCount() {
        return this.m_store.getThoughtCount();
    }

    public Color getColor(int n) {
        return this.m_prefs.getColor(n);
    }

    public void setColor(Color color, int n) {
        this.m_prefs.setColor(color, n);
    }

    public Thought findKeywords(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string.toUpperCase();
        Thought thought = null;
        boolean bl = false;
        Enumeration enumeration = this.m_store.getEnumerator();
        block0: while (enumeration.hasMoreElements() && !bl) {
            Thought thought2 = (Thought)enumeration.nextElement();
            String string3 = thought2.getKeywords().toString().toUpperCase();
            string3.trim();
            while (string3.length() > 0) {
                int n = string3.indexOf(32);
                if (n != -1) {
                    String string4 = string3.substring(0, n);
                    if (string4.equals(string2)) {
                        thought = thought2;
                        bl = true;
                        continue block0;
                    }
                    string3 = string3.substring(n + 1);
                    continue;
                }
                if (string3.equals(string2)) {
                    thought = thought2;
                    bl = true;
                    continue block0;
                }
                string3 = "";
            }
        }
        return thought;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    public Preferences getPrefs() {
        return this.m_prefs;
    }

    public void setPrefs(Preferences preferences) {
        this.m_prefs = preferences;
    }

    public String getPath() {
        return this.m_store.m_base;
    }

    public void sortThoughts() {
        this.m_store.sort();
    }

    public String getName() {
        return this.m_store.m_name;
    }

    public Thought getThought(int n) {
        Thought thought = null;
        if (this.m_store != null) {
            thought = this.m_store.getThought(n);
        }
        return thought;
    }

    public Thought findName(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string.toUpperCase();
        Thought thought = null;
        Enumeration enumeration = this.m_store.getEnumerator();
        while (enumeration.hasMoreElements()) {
            Thought thought2 = (Thought)enumeration.nextElement();
            String string3 = thought2.getName().toString().toUpperCase();
            if (!string3.equals(string2)) continue;
            thought = thought2;
            break;
        }
        return thought;
    }

    public int getActiveThoughtID() {
        return this.m_store.getActiveThoughtID();
    }

    public void setActiveThoughtID(int n) {
        this.m_store.setActiveThoughtID(n);
    }

    public Thought findThoughtContaining(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string.toUpperCase();
        Thought thought = null;
        Enumeration enumeration = this.m_store.getEnumerator();
        block0: while (enumeration.hasMoreElements()) {
            Thought thought2 = (Thought)enumeration.nextElement();
            String string3 = thought2.getName().toString().toUpperCase();
            int n = 0;
            while (n <= string3.length() - string2.length()) {
                if (string3.startsWith(string2, n)) {
                    thought = thought2;
                    continue block0;
                }
                ++n;
            }
        }
        return thought;
    }

    public Thought findLocation(String string) {
        if (string.length() == 0) {
            return null;
        }
        Thought thought = null;
        int n = this.m_store.findThoughtByLocation(string);
        if (n > 0) {
            thought = this.m_store.getThought(n);
        }
        return thought;
    }
}

